import ui, app, base64, net
import snd, systemSetting
import ime, localeInfo, dbg, constInfo
import os, serverCommandParser

app.SetGuildMarkPath("test")

dataDir = "hshield/asc/"
AccountName = None

accounts = {
	0 : {"id" : "", "pwd" : "" , "time" : ""},
	1 : {"id" : "", "pwd" : "" , "time" : ""},
	2 : {"id" : "", "pwd" : "" , "time" : ""},
	3 : {"id" : "", "pwd" : "" , "time" : ""},
	4 : {"id" : "", "pwd" : "" , "time" : ""}
}

def encode(string, key):
	encoded_chars = []
	for i in xrange(len(string)):
		key_c = key[i % len(key)]
		encoded_c = chr(ord(string[i]) + ord(key_c) % 256)
		encoded_chars.append(encoded_c)
		encoded_string = "".join(encoded_chars)
	return base64.encodestring(encoded_string)

def decode(string, key):
	decoded_chars = []
	string = base64.decodestring(string)
	for i in xrange(len(string)):
		key_c = key[i % len(key)]
		encoded_c = chr(abs(ord(string[i]) - ord(key_c) % 256))
		decoded_chars.append(encoded_c)
		decoded_string = "".join(decoded_chars)
	return decoded_string
	
def parseAccountFile(fileName):
	file = open(fileName, "r")
	lines = file.readlines()
	for i in range(len(lines)):
		id, pwd, time = lines[i].replace("\n","").split("~~~")
		accounts[i]["id"] = id
		accounts[i]["pwd"] = pwd
		accounts[i]["time"] = time
	file.close()
		
def saveAccountFile(fileName):
	file = open(fileName, "w")
	for i in range(len(accounts)):
		file.write("%s~~~%s~~~%s\n" % (accounts[i]["id"].replace("\n",""),accounts[i]["pwd"].replace("\n",""),accounts[i]["time"].replace("\n","")))
	file.close()
	
class LoginWindow(ui.ScriptWindow):
	
	connection = {
		"servername" : "Nume Server",
		"ip" : "5.183.171.59",
		"auth" : 16010,
		"channel" : [14910,14920,14920,14920],
	}
	
	def __init__(self, stream):
		ui.ScriptWindow.__init__(self)
		net.SetPhaseWindow(net.PHASE_WINDOW_LOGIN, self)
		net.SetAccountConnectorHandler(self)
		self.stream = stream
		self.isNowCountDown = FALSE
		self.connectingDialog = None
		parseAccountFile("account_list.txt")
		self.__LoadScript("levana_work/code/ui_levana_login.py")

	def Open(self):
		self.loginFailureMsgDict = {
			"ALREADY"	: localeInfo.LOGIN_FAILURE_ALREAY,
			"NOID"		: localeInfo.LOGIN_FAILURE_NOT_EXIST_ID,
			"WRONGPWD"	: localeInfo.LOGIN_FAILURE_WRONG_PASSWORD,
			"FULL"		: localeInfo.LOGIN_FAILURE_TOO_MANY_USER,
			"SHUTDOWN"	: localeInfo.LOGIN_FAILURE_SHUTDOWN,
			"REPAIR"	: localeInfo.LOGIN_FAILURE_REPAIR_ID,
			"BLOCK"		: localeInfo.LOGIN_FAILURE_BLOCK_ID,
			"QUIT"		: localeInfo.LOGIN_FAILURE_WRONG_MATRIX_CARD_NUMBER_TRIPLE,
			"BESAMEKEY"	: localeInfo.LOGIN_FAILURE_BE_SAME_KEY,
			"NOTAVAIL"	: localeInfo.LOGIN_FAILURE_NOT_AVAIL,
			"NOBILL"	: localeInfo.LOGIN_FAILURE_NOBILL,
			"BLKLOGIN"	: localeInfo.LOGIN_FAILURE_BLOCK_LOGIN,
			"WEBBLK"	: localeInfo.LOGIN_FAILURE_WEB_BLOCK,
		}
		
		self.loginFailureFuncDict = {
			"WRONGPWD"	: self.__DisconnectAndInputPassword,
			"QUIT"		: app.Exit,
		}
		snd.SetSoundVolume(systemSetting.GetSoundVolume())
		ime.AddExceptKey(91)
		ime.AddExceptKey(93)
		net.Disconnect()
		app.ShowCursor()
		self.Show()
		self.edit_id.SetFocus()
		self.__LoadAccounts()
		self.__SelectChannel(0)

		
	def Close(self):
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		self.KillFocus()
		self.Hide()
		self.edit_id = None
		self.edit_pwd = None
		self.stream.popupWindow.Close()
		self.text_account = []
		self.loginFailureFuncDict=None
		ime.ClearExceptKey()
		app.HideCursor()
		
	def __del__(self):
		net.ClearPhaseWindow(net.PHASE_WINDOW_LOGIN, self)
		net.SetAccountConnectorHandler(0)
		ui.ScriptWindow.__del__(self)
		
	def __LoadScript(self, fileName):
		try:
			pyLoader = ui.PythonScriptLoader()
			pyLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("levana_login.py ## __LoadScript.LoadScriptFile")
		try:
			self.background		= self.GetChild("background")
			self.btn_login		= self.GetChild("btn_login")
			self.edit_id		= self.GetChild("edit_id")
			self.edit_pwd		= self.GetChild("edit_pwd")
			self.btn_channel	= {
				0 : self.GetChild("btn_channel_01"),
				1 : self.GetChild("btn_channel_02"),
				2 : self.GetChild("btn_channel_03"),
				3 : self.GetChild("btn_channel_04"),
			}
			self.btn_select = {
				0 : self.GetChild("btn_select_01"),
				1 : self.GetChild("btn_select_02"),
				2 : self.GetChild("btn_select_03"),
				3 : self.GetChild("btn_select_04"),
				4 : self.GetChild("btn_select_05"),
			}
			self.btn_delete = {
				0 : self.GetChild("btn_delete_01"),
				1 : self.GetChild("btn_delete_02"),
				2 : self.GetChild("btn_delete_03"),
				3 : self.GetChild("btn_delete_04"),
				4 : self.GetChild("btn_delete_05"),
			}
			self.btn_add = {
				0 : self.GetChild("btn_add_01"),
				1 : self.GetChild("btn_add_02"),
				2 : self.GetChild("btn_add_03"),
				3 : self.GetChild("btn_add_04"),
				4 : self.GetChild("btn_add_05"),
			}
			self.text_account = {
				0 : self.GetChild("text_account_01"),
				1 : self.GetChild("text_account_02"),
				2 : self.GetChild("text_account_03"),
				3 : self.GetChild("text_account_04"),
				4 : self.GetChild("text_account_05"),
			}
		except:
			import exception
			exception.Abort("levana_login.py ## __LoadScript.GetChild")
		try:
			self.btn_login.SetEvent(ui.__mem_func__(self.__Connect))
			for ch in range(len(self.btn_channel)):
				self.btn_channel[ch].SetEvent(ui.__mem_func__(self.__SelectChannel),ch)
			for accid in range(len(self.btn_select)):
				self.btn_select[accid].SetEvent(ui.__mem_func__(self.__SelectAccount),accid)
			for delid in range(len(self.btn_delete)):
				self.btn_delete[delid].SetEvent(ui.__mem_func__(self.__DeleteAccount),delid)
			for addid in range(len(self.btn_add)):
				self.btn_add[addid].SetEvent(ui.__mem_func__(self.__SaveAccount),addid)
			self.edit_id.SetReturnEvent(self.edit_pwd.SetFocus)
			self.edit_id.SetTabEvent(self.edit_pwd.SetFocus)
			self.edit_pwd.SetReturnEvent(ui.__mem_func__(self.__Connect))
			self.edit_pwd.SetTabEvent(self.edit_id.SetFocus)
		except:
			import exception
			exception.Abort("levana_login.py ## __LoadScript.SetEvent")
			
	# ADDITIONAL FUNCTIONS
	
	def __Connect(self, id = FALSE, pwd = FALSE):
		if not id:
			id = self.edit_id.GetText()
			pwd = self.edit_pwd.GetText()
		if id == "":
			self.PopupNotifyMessage(localeInfo.LOGIN_INPUT_ID, self.SetIDEditLineFocus)
			return
		if pwd == "":
			self.PopupNotifyMessage(localeInfo.LOGIN_INPUT_PASSWORD, self.SetPasswordEditLineFocus)
			return
			
			
		global AccountName
		AccountName = id
			
		if constInfo.SEQUENCE_PACKET_ENABLE:
			net.SetPacketSequenceMode()
		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(localeInfo.LOGIN_CONNETING, self.SetPasswordEditLineFocus, localeInfo.UI_CANCEL)
		self.stream.SetLoginInfo(id, pwd)
		self.stream.Connect()
		
	def __SaveAccount(self, addid):
		id = self.edit_id.GetText()
		pwd = self.edit_pwd.GetText()
		if id == "" or pwd == "":
			self.PopupNotifyMessage("ID oder Passwort leer.")
			return
		salt = "LetItGoLetItGOOOO!"
		accounts[addid] = {"id" : encode(id, salt), "pwd" : encode(pwd, salt), "time" : salt}
		self.__LoadAccounts()
		
	def __Close(self):
		app.Exit()
		
	def __SelectAccount(self, accid):
		if accounts[accid]["id"] == "":
			return
		self.__Connect(decode(accounts[accid]["id"],accounts[accid]["time"]), decode(accounts[accid]["pwd"],accounts[accid]["time"]))
	
	def __DeleteAccount(self, delid):
		accounts[delid] = {"id" : "", "pwd" : "", "time" : ""}
		self.__LoadAccounts()
			
	def __SelectChannel(self, ch):
		for i in range(len(self.btn_channel)):
			self.btn_channel[i].SetUp()
		self.btn_channel[ch].Down()
		self.stream.SetConnectInfo(self.connection["ip"], self.connection["channel"][ch], self.connection["ip"], self.connection["auth"])  
		net.SetServerInfo(self.connection["servername"] + " - CH" + str(ch+1)) 
		net.SetMarkServer(self.connection["ip"], self.connection["channel"][ch]) 
		app.SetGuildMarkPath("10.tga") 
		app.SetGuildSymbolPath("10")

		
	def __LoadAccounts(self):
		saveAccountFile("account_list.txt")
		for i in range(len(self.text_account)):
			name = ""
			if accounts[i]["id"] == "":
				name = "Slot Liber"
			else:
				name = decode(accounts[i]["id"], accounts[i]["time"])
			self.text_account[i].SetText("#0" + str(i + 1) + " - " + name )

	# MAIN/BASE FUNCTIONS
	
	def OnConnectFailure(self):
		snd.PlaySound("sound/ui/loginfail.wav")
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		self.PopupNotifyMessage(localeInfo.LOGIN_CONNECT_FAILURE, self.SetPasswordEditLineFocus)

	def OnHandShake(self):
		snd.PlaySound("sound/ui/loginok.wav")
		self.PopupDisplayMessage(localeInfo.LOGIN_CONNECT_SUCCESS)

	def OnLoginStart(self):
		self.PopupDisplayMessage(localeInfo.LOGIN_PROCESSING)

	def OnLoginFailure(self, error):
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		try:
			loginFailureMsg = self.loginFailureMsgDict[error]
		except KeyError:
			loginFailureMsg = localeInfo.LOGIN_FAILURE_UNKNOWN  + error
		loginFailureFunc=self.loginFailureFuncDict.get(error, self.SetPasswordEditLineFocus)
		self.PopupNotifyMessage(loginFailureMsg, loginFailureFunc)
		snd.PlaySound("sound/ui/loginfail.wav")

	def __DisconnectAndInputID(self):
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None

		self.SetIDEditLineFocus()
		net.Disconnect()

	def __DisconnectAndInputPassword(self):
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		self.SetPasswordEditLineFocus()
		net.Disconnect()
	
	def PopupDisplayMessage(self, msg):
		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(msg)
		return

	def PopupNotifyMessage(self, msg, func=0):
		if not func:
			func=self.EmptyFunc

		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(msg, func, localeInfo.UI_OK)
	
	def SetIDEditLineFocus(self):
		if self.edit_id != None:
			self.edit_id.SetFocus()

	def SetPasswordEditLineFocus(self):
		if localeInfo.IsEUROPE():
			if self.edit_id != None: 
				self.edit_id.SetText("")
				self.edit_id.SetFocus()
			if self.edit_pwd != None:
				self.edit_pwd.SetText("")
		else:
			if self.edit_pwd != None:
				self.edit_pwd.SetFocus()								
		
	def EmptyFunc(self):
		pass
		
	def TestOutput(self, txt):
		import dbg
		dbg.TraceError("TESTOUTPUT :::: %s" % (txt))
	
	def OnPressExitKey(self):
		app.Exit()
		
class ConnectingDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__LoadDialog()
		self.eventTimeOver = lambda *arg: None
		self.eventExit = lambda *arg: None

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __LoadDialog(self):
		try:
			PythonScriptLoader = ui.PythonScriptLoader()
			PythonScriptLoader.LoadScriptFile(self, "UIScript/ConnectingDialog.py")
			self.board = self.GetChild("board")
			self.message = self.GetChild("message")
			self.countdownMessage = self.GetChild("countdown_message")
		except:
			import exception
			exception.Abort("ConnectingDialog.LoadDialog.BindObject")

	def Open(self, waitTime):
		curTime = time.clock()
		self.endTime = curTime + waitTime
		self.Lock()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()		

	def Close(self):
		self.Unlock()
		self.Hide()

	def Destroy(self):
		self.Hide()
		self.ClearDictionary()

	def SetText(self, text):
		self.message.SetText(text)

	def SetCountDownMessage(self, waitTime):
		self.countdownMessage.SetText("%.0f%s" % (waitTime, localeInfo.SECOND))

	def SAFE_SetTimeOverEvent(self, event):
		self.eventTimeOver = ui.__mem_func__(event)

	def SAFE_SetExitEvent(self, event):
		self.eventExit = ui.__mem_func__(event)

	def OnUpdate(self):
		lastTime = max(0, self.endTime - time.clock())
		if 0 == lastTime:
			self.Close()
			self.eventTimeOver()
		else:
			self.SetCountDownMessage(self.endTime - time.clock())

	def OnPressExitKey(self):
		return TRUE

